package cn.com.duiba.kjy.api.remoteservice.appvideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoTemplateDetailDto;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoTemplateDto;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoTemplateLinkedDetailDto;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoTemplateMigrateDto;
import cn.com.duiba.kjy.api.params.appvideo.AppVideoTemplateSearchParam;

import java.util.List;
import java.util.Map;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-08-09 14:25
 * 视频模板rpc
 */
@AdvancedFeignClient
public interface RemoteAppVideoTemplateApiService {

    /**
     * 查询视频模板列表（仅管理后台可用）
     * @param classificationId 栏目id（可为空）
     * @return 模板列表
     */
    long countTemplate(Long classificationId);

    /**
     * 查询视频模板列表（不带ext）
     * @param param 查询参数
     * @return 模板列表
     */
    List<AppVideoTemplateDto> searchListWithCache(AppVideoTemplateSearchParam param);

    /**
     * 获取当前视频模板
     * @param templateId 模板id
     * @return 视频模板及ext信息
     */
    AppVideoTemplateDetailDto findDetailById(Long templateId);

    /**
     * 获取当前视频模板（包含前一个后一个id）
     * @param templateId 模板id
     * @return 视频模板及ext信息
     */
    AppVideoTemplateLinkedDetailDto findLinkedDetailById(Long templateId);

    /**
     * 获取当前视频模板（带ext）
     * @param param 查询参数
     * @return 视频模板及ext信息
     */
    List<AppVideoTemplateDetailDto> searchDetailList(AppVideoTemplateSearchParam param);

    /**
     * 新增视频模板
     * @param insertDetail 视频模板
     * @return 视频模板id
     */
    boolean insert(AppVideoTemplateDetailDto insertDetail);

    /**
     * 编辑视频模板
     * @param updateDetail 视频模板
     * @return 编辑结果
     */
    boolean update(AppVideoTemplateDetailDto updateDetail);

    /**
     * 批量修改视频模板
     * @param updateList 模板id
     * @return 批量修改结果
     */
    int batchUpdate(List<AppVideoTemplateDto> updateList);

    /**
     * 删除视频模板
     * @param id 模板id
     * @return 删除结果
     */
    boolean deleteById(Long id);

}
