package cn.com.duiba.kjy.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.companyProduct.CompanyProductDto;
import cn.com.duiba.kjy.api.params.company.CompanyProductListParam;

import java.util.List;

/**
 * 公司产品管理
 * @Author chentiecheng
 * @Date 2020/5/9 11:53 上午
 */
@AdvancedFeignClient
public interface RemoteCompanyProductService {
    /**
     * 统计总数
     * @param param
     * @return
     */
    Long selectCount(CompanyProductListParam param);

    /**
     * 根据条件分页查询公司产品列表
     * @param param
     * @return
     */
    List<CompanyProductDto> selectListByParam(CompanyProductListParam param);

    /**
     * 新增公司产品
     * @param dto
     * @return
     */
    Boolean insert(CompanyProductDto dto);

    /**
     * 更新公司产品
     * @param dto
     * @return
     */
    Boolean update(CompanyProductDto dto);

    /**
     * 删除公司产品
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 根据id查询公司产品
     * @param id
     * @return
     */
    CompanyProductDto selectById(Long id);
}
