package cn.com.duiba.kjy.api.remoteservice.dailyPostersConfig;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.dailypostersconfig.DailyPostersGalleryDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.dailyPosters.GallerySearchParams;
import cn.com.duiba.kjy.api.params.dailyPosters.StickStateSetParam;

/**
 * @author linjianhui
 * @description 早晚安图库
 * @date 2020/11/14 10:58
 */
@AdvancedFeignClient
public interface RemoteDailyPostersGalleryService {

    /**
     * 新增/更新早晚安图库
     * @param dto
     * @return
     */
    Long addOrUpdate(DailyPostersGalleryDto dto);

    /**
     * 获取早晚安图库列表
     * @param params
     * @return
     */
    Page<DailyPostersGalleryDto> selectPage(GallerySearchParams params);

    /**
     * 根据主键id查询
     * @param id
     * @return
     */
    DailyPostersGalleryDto findById(Long id);

    /**
     * 根据id删除图库
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 置顶图片
     * @param param
     * @return
     */
    Integer updateStickState(StickStateSetParam param);

    /**
     * 根据id增加一次使用次数
     * @param id
     * @return
     */
    Integer updateUseNum(Long id);

}
