package cn.com.duiba.kjy.api.remoteservice.wx.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.wx.tag.WxTagDto;

import java.util.List;

/**
 * 微信标签
 * @author lizhi
 * @date 2020/10/10 2:32 PM
 */
@AdvancedFeignClient
public interface RemoteOaWxTagService {

    /**
     * 根据oaId+tagType，查询已有标签，若没有，则新增，有返回null
     * @param dto 标签
     * @return 标签
     */
    WxTagDto save(WxTagDto dto);

    /**
     * 根据oaId+tagType查询
     * @param oaId 公众号ID
     * @param tagType 类型
     * @see cn.com.duiba.kjy.api.enums.wx.WxTagTypeEnum
     * @return 标签
     */
    WxTagDto findByOaIdAndTagType(Long oaId, Integer tagType);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 标签
     */
    WxTagDto selectById(Long id);

    /**
     * 查询公众号下所有标签
     * @param oaId 公众号ID
     * @return 标签集合
     */
    List<WxTagDto> selectByOaId(Long oaId);

    /**
     * 更新
     * @param dto 标签
     * @return 执行结果
     */
    int update(WxTagDto dto);

    /**
     * 删除标签
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
