package cn.com.duiba.kjy.api.dto.autoreply.v2;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: HanYLun
 * @description: 自动回复配置参数
 * @create: 2021-08-17 4:41 下午
 */
@Data
public class AutoReplyBaseInfoDto implements Serializable {

    private static final long serialVersionUID = 4115606213001069937L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 关键字
     */
    @NotNull(message = "关键字不能为空")
    private String replyContent;


    /**
     * 期限类型 1：非永久 2：永久
     */
    @NotNull(message = "期限类型不能为空")
    private Integer periodType;

    /**
     * 生效时间（开始）
     */
    private Date effectiveTimeStart;

    /**
     * 生效时间（结束）
     */
    private Date effectiveTimeEnd;

    /**
     * 备注
     * max length = 255
     */
    private String remarks;


}
