package cn.com.duiba.kjy.api.enums;

import cn.com.duiba.kjy.api.util.NumberUtil;

import java.util.Objects;

/**
 * @author lizhi
 * @date 2019/6/29 2:12 PM
 */
public enum CompanyDocumentTypeEnum {
    //公司资料类型及名称
    WORD(1, "Word"),
    PPT(2, "PPT"),
    EXCEL(3, "Excel"),
    PDF(4, "PDF"),
    VIDEO(5, "视频"),
    PICTURE(6, "图片"),
    TXT(7, "文本"),
    ARTICLE(8, "文章"),
    ;

    private Integer type;

    private String typeName;

    CompanyDocumentTypeEnum(Integer type, String typeName) {
        this.type = type;
        this.typeName = typeName;
    }

    public static CompanyDocumentTypeEnum getByType(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return null;
        }
        for (CompanyDocumentTypeEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getTypeName() {
        return typeName;
    }
}
