package cn.com.duiba.kjy.api.enums.marketing;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liuchao1
 * @date 2020/2/24 19:48
 */
public enum VisitorMarketingGiftReceiveStateEnum {

    NOT_RECEIVE(0, "未领取"),

    RECEIVING(1, "领取中"),

    RECEIVE_SUCCESS(2, "领取成功"),

    RECEIVE_FAIL(3, "领取失败"),

    ;

    private Integer code;
    private String desc;

    VisitorMarketingGiftReceiveStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, VisitorMarketingGiftReceiveStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(VisitorMarketingGiftReceiveStateEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static VisitorMarketingGiftReceiveStateEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public boolean canReceive(){
        return this == NOT_RECEIVE;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
