package cn.com.duiba.kjy.api.enums.reward;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author wangbinbin
 * @create 2021-03-16 10:16
 * @descript 点对点推送枚举
 */
@AllArgsConstructor
@Getter
public enum RewardPushTypeEnum {

    /**
     * 中奖结果通知
     */
    L35(1, "中奖结果通知", 224),
    ;

    /**
     * 代码
     */
    private final Integer code;

    /**
     * 代码描述
     */
    private final String description;

    /**
     * 模版消息id
     */
    private final Integer markId;

    /**
     * 根据消息模版id查询推送代码
     */
    public static List<Integer> getCodesByMarks(List<Integer> marks) {
        if (CollectionUtils.isEmpty(marks)) {
            return Collections.emptyList();
        }
        return Arrays.stream(RewardPushTypeEnum.values()).filter(e -> marks.contains(e.markId))
                .map(RewardPushTypeEnum::getCode).collect(Collectors.toList());
    }
}
