package cn.com.duiba.kjy.api.params;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by zhangshun on 2019/6/3.
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class SellerSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = -2983371748132642436L;

    /**
     * 代理人Id
     */
    private Long sellerId;
    private Long companyId;
    private Integer vip;
    private Integer deleted;
    /**
     * 是否按照创建倒序，默认倒序
     */
    private boolean gmtCreateDesc = true;

    /**
     * 微信昵称
     */
    private String wxNickname;

    /**
     * 代理人手机号
     */
    private String sellerPhone;

    /**
     * 时间次序
     */
    public String getGmtCreateOrder() {
        return gmtCreateDesc ? "desc" : "asc";
    }

    /**
     * 创建时间
     */
    private Date gmtCreate;
}
