package cn.com.duiba.kjy.api.params.autoreply.v2;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author: HanYLun
 * @description: 自动回复搜索内容
 * @create: 2021-08-17 7:27 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AutoReplySearchParams extends PageQuery {

    /**
     *
     *回复内容
     * max length = 64
     * not null default = null
     */
    private String replyContent;

    /**
     *
     *状态，1=启用、2=未启用
     * not null default = 1
     */
    private Integer state;

    /**
     * 期限类型 1：非永久 2：永久
     */
    private Integer periodType;
}
