package cn.com.duiba.kjy.api.remoteservice.autoreply;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.autoreply.AutoReplyConfigDto;
import cn.com.duiba.kjy.api.dto.autoreply.AutoReplyDetailDto;
import cn.com.duiba.kjy.api.dto.autoreply.AutoReplyDto;
import cn.com.duiba.kjy.api.dto.autoreply.ReceiveTextDto;
import cn.com.duiba.kjy.api.dto.autoreply.v2.AutoReplyConfDto;
import cn.com.duiba.kjy.api.enums.autoreply.AutoReplyStateEnum;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.autoreply.AutoReplySearchParams;
import cn.com.duiba.user.service.api.dto.oa.OfficialAccountDto;

import java.util.List;

/**
 * @auther: linjianhui
 * @date: 2020-03-02 11:50
 * @description: 自动回复相关
 */
@AdvancedFeignClient
public interface RemoteAutoReplyService {

    /**
     * 新增自动回复
     * @param dto
     * @return
     */
    Long save(AutoReplyDetailDto dto);

    /**
     * 检查创建/编辑参数是否合法
     * @param dto
     * @return
     */
    Boolean checkAutoReply(AutoReplyDetailDto dto);

    /**
     * 编辑自动回复
     * @param dto
     * @return
     */
    Integer update(AutoReplyDetailDto dto);

    /**
     * 启用/未启用
     * @param id
     * @param state
     * @return
     */
    Boolean changeState(Long id, AutoReplyStateEnum state);

    /**
     * 通过id删除
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 通过id查询
     * @param id
     * @return
     */
    AutoReplyDetailDto findById(Long id);

    /**
     * 查询自动回复列表
     * @param params
     * @return
     */
    Page<AutoReplyDetailDto> selectList(AutoReplySearchParams params);

    /**
     * 给指定代理人试推
     * @param id 自动回复id
     * @param sellerId 代理人id
     * @return
     */
    Boolean tryAutoReply(Long id, Long sellerId);

    /**
     * 根据代理人回复，自动回复
     * @param officialAccountDto 回复的账号
     * @param receiveTextDto 回复的信息
     * @return
     */
    Boolean autoReply(OfficialAccountDto officialAccountDto, ReceiveTextDto receiveTextDto);

    /**
     * 根据自动回复基本配置id查询对应的配置信息
     * @param id    自动回复基本配置id
     * @return  对应的配置信息
     */
    cn.com.duiba.kjy.api.dto.autoreply.v2.AutoReplyDto findAutoReplyById(Long id);

    /**
     * 根据筛选条件查询对应的自动回复列表信息
     * @param params    筛选条件
     * @return  对应的自动回复信息
     */
    Page<AutoReplyDto> selectListByParams(cn.com.duiba.kjy.api.params.autoreply.v2.AutoReplySearchParams params);

    /**
     * 新增自动回复,新增基本配置和回复内容
     * @param dto   基本配置和回复内容
     * @return  基本配置的主键
     */
    Long save(cn.com.duiba.kjy.api.dto.autoreply.v2.AutoReplyDto dto);

    /**
     * 更新自动回复,更新基本配置和回复内容
     * @param dto   基本配置和回复内容
     * @return  更新的条数
     */
    Integer update(cn.com.duiba.kjy.api.dto.autoreply.v2.AutoReplyDto dto) throws KjyCenterException;

}
