package cn.com.duiba.kjy.api.dto.autoreply.v2;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: HanYLun
 * @description: 自动回复配置信息
 * @create: 2021-08-17 7:27 下午
 */
@Data
public class AutoReplyConfDto implements Serializable {

    private static final long serialVersionUID = -7396125957640565867L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 推送记录ID
     */
    private Long autoReplyId;


    /**
     * 2:客服文字消息 3:客服图文消息（卡片） 4:客服图片消息,6:客服小程序卡片消息
     *
     * @see cn.com.duiba.kjy.api.enums.MessageConfigTypeEnum
     */
    private Integer messageType;

    /**
     * 卡片标题
     */
    private String title;

    /**
     * 卡片描述
     */
    private String pushDesc;

    /**
     * 卡片缩略图
     */
    private String mainImgUrl;

    /**
     * 卡片跳转地址
     */
    private String jumpPath;

    /**
     * 客服文字消息的内容
     */
    private String customWords;

    /**
     * 图片消息的微信返回的ID
     */
    private String picMediaId;

    /**`
     * 小程序卡片消息的小程序ID
     */
    private String mpId;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 缩略图
     */
    private String thumbnailUrl;

    /**
     *
     *是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Integer deleted;

}
