package cn.com.duiba.kjy.api.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * 销售CRM权限枚举
 * @author zhanghuifeng
 * date 2020/12/3-17:36
 */
public enum CrmSellerRoleTypeEnum {

    SELLER(1, "销售"),
    MASTER(2, "管理员"),

    ;

    private Integer code;
    private String desc;

    CrmSellerRoleTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CrmSellerRoleTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CrmSellerRoleTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static CrmSellerRoleTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
