package cn.com.duiba.kjy.api.enums.crm.contract;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linjianhui
 * @description 签署状态
 * @date 2021/3/16 19:52
 */
public enum CrmContractCompleteEnum {

    /**
     * 签署状态 1：未签署 2：已签署
     */
    BEFORE_LIVE(1, "未签署"),
    AFTER_LIVE(2,"已签署"),
    ;

    private Integer code;

    private String desc;

    CrmContractCompleteEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CrmContractCompleteEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CrmContractCompleteEnum completeEnum : values()){
            ENUM_MAP.put(completeEnum.getCode(), completeEnum);
        }
    }

    public static CrmContractCompleteEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
