package cn.com.duiba.kjy.api.dto.wx.menu;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信公众号菜单表
 * @author kjj mybatis generator 
 * @date 2020-10-09
 */
@Data
public class WxMenuDto implements Serializable {
     
    private static final long serialVersionUID = 16022140871305523L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 菜单所属公众号主键，tb_official_accounts.id
     */
    private Long oaId;

    /**
     * 菜单类型，1-默认菜单，2-个性化菜单
     * @see cn.com.duiba.kjy.api.enums.wx.WxMenuTypeEnum
     */
    private Integer menuType;

    /**
     * 菜单名称，相当于备注
     */
    private String menuName;

    /**
     * 菜单内容json
     */
    private String menuContent;

    /**
     * 微信菜单ID
     */
    private String wxMenuId;

    /**
     * 菜单状态：1-未启用，2-已启用，3-已下架
     * @see cn.com.duiba.kjy.api.enums.wx.WxMenuStatusEnum
     */
    private Integer menuStatus;

    /**
     * 是否删除，1=已删除，0=未删除
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}