package cn.com.duiba.kjy.api.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * 销售CRM业务线枚举
 * @author zhanghuifeng
 * date 2020/12/3-17:36
 */
public enum CrmSellerBizTypeEnum {

    LIVE(1, "直播线"),

    ;

    private Integer code;
    private String desc;

    CrmSellerBizTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CrmSellerBizTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CrmSellerBizTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static CrmSellerBizTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
