package cn.com.duiba.kjy.api.dto.sms;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 推送任务列表
 * @author kjj mybatis generator 
 * 2021-05-27
 */
@Data
public class SmsPushDto implements Serializable {
    private static final long serialVersionUID = 16220815032719021L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *签名ID,tb_sms_signature.id
     */
    private Long smsSignatureId;

    /**
     *
     *模版ID,tb_sms_template.id
     * not null default = null
     */
    private Long smsTemplateId;

    /**
     *
     *推送人群 1:用户ID录入 2:手机号录入
     */
    private Byte pushCrowd;

    /**
     *
     *推送状态 0:内容审核中 1:内容审核失败 2:未发送 3:已发送 4:已停用
     * not null default = 0
     */
    private Byte pushStatus;

    /**
     *
     *备注
     * max length = 30
     */
    private String pushRemark;

    /**
     *
     *是否开启定时任务 1:不开启定时任务 2:开启定时任务
     */
    private Byte timingStatus;

    /**
     *
     *定时时间
     */
    private Date pushTiming;

    /**
     *
     *发送时间
     */
    private Date sendTime;

    /**
     *
     *上传名单excel
     * max length = 100
     */
    private String excelUrl;

    /**
     *
     *导入名单总数
     */
    private Long importNumber;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}