package cn.com.duiba.kjy.api.enums.corp;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author: HanYaLun
 * @description: 管理员类型
 * @create: 2021-08-24 7:29 下午
 */
@Getter
@AllArgsConstructor
public enum StaffTypeEnum {

    /**
     * 超级管理员
     */
    SUPER_ADMIN(1, "超级管理员", true),

    /**
     * 管理员
     */
    ORDINARY_ADMIN(2, "管理员", false);

    /**
     * 状态
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 是否启用(前端是否可勾选)
     */
    private final Boolean enable;
}
