package cn.com.duiba.kjy.api.enums.orderRefund;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linjianhui
 * @description 退款申请来源
 * @date 2020-07-02 11:53
 */
public enum RefundSourceEnum {

    /**
     * 退款申请来源
     */
    ADMIN(1, "内部人员管理后台操作发起"),
    SYSTEM(2,"完成60天打卡任务，系统发起"),
    USER_CLOCK_FINISH(3,"完成180天打卡任务,用户发起")
    ;

    private Integer code;
    private String desc;

    RefundSourceEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, RefundSourceEnum> ENUM_MAP = new HashMap<>();

    static{
        for(RefundSourceEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static RefundSourceEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
