package cn.com.duiba.kjy.api.remoteservice.appvideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoBannerDto;

import java.util.List;

/**
 * @author likui
 * @date 2021/10/11 4:26 下午
 **/
@AdvancedFeignClient
public interface RemoteAppVideoBannerApiService {
    /**
     * 插入
     * @param bannerDto bannerDto
     * @return 操作结果
     */
    int inset(AppVideoBannerDto bannerDto);

    /**
     * 更新
     * @param bannerDto bannerDto
     * @return 操作结果
     */
    int update(AppVideoBannerDto bannerDto);

    /**
     * 查询banner列表
     * @param offset 偏移量
     * @param pageSize 每页条数
     * @param state banner状态
     * @return banner列表
     */
    List<AppVideoBannerDto> selectList(Integer offset,Integer pageSize,Integer state);

    /**
     * 上架/下架banner
     * @param state banner状态
     * @param id banner主键值
     * @return 操作结果
     */
    int putOnOrOff(Integer state,Long id);

    /**
     * 查询记录条数
     * @return 记录条数
     */
    Integer selectCount();

    /**
     * 查询上架的banner数量
     * @param state banner状态
     * @return 上架的banner数量
     */
    Integer selectShelfCount(Integer state);

    /**
     * 根据ID查询banner
     * @param id 主键值
     * @return bannerDto
     */
    AppVideoBannerDto selectOne(Long id);

    /**
     * 删除
     * @param id 主键值
     * @return 操作结果
     */
    Integer delete(Long id);

    /**
     * 管理后台banner位上下移
     * @param id banner主键
     * @param moveType 1：上移，2：下移
     */
    void sort(Long id,int moveType);
}
