package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.pub.PubUserCustomerDto;
import cn.com.duiba.kjy.api.params.PageQuery;

import java.util.Date;
import java.util.List;

/**
 * 公共空间-客户
 *
 * @author xuzhigang
 * @date 2021/11/1 1:51 下午
 **/
@AdvancedFeignClient
public interface RemotePubUserCustomerService {

    /**
     * 根据userId分页查询客户
     * @param pageQuery 分页参数
     * @param userId 用户id
     * @param startDate 开始日期
     * @return 客户列表
     */
    List<PubUserCustomerDto> selectPage(PageQuery pageQuery, Long userId, Date startDate);

    /**
     * 批量新增或更新
     *
     * @param list 客户信息
     * @return 执行结果
     */
    void batchInsertOrUpdate(List<PubUserCustomerDto> list);

    /**
     * 批量删除
     *
     * @param list 客户信息列表
     * @return 执行结果
     */
    void batchDelete(List<PubUserCustomerDto> list);

    /**
     * 根据用户id和客户用户id查询
     *
     * @param userId 用户id
     * @param customerUserId 客户用户id
     * @return 客户信息
     */
    PubUserCustomerDto selectByUser(Long userId, Long customerUserId);
}