package cn.com.duiba.kjy.api.params.faq;

import lombok.Data;

import java.io.Serializable;

/**
 * Created by xiaotian
 * time 2020/07/03 14:28.
 */
@Data
public class SendPushForScanParam  implements Serializable {

    private static final long serialVersionUID = 3094392963321996128L;

    /**
     * 访客Id
     */
    private Long visitId;

    /**
     * 销售Id
     */
    private Long sellerId;

    /**
     * 销售员文章id
     */
    private Long   scId;

    /**
     * 指定线索类型
     * @see cn.com.duiba.kjy.api.enums.clue.VisitClueTypeEnum
     */
    private String clueTypeName;

    /**
     * 问答id
     */
    private Long   qId;

    /**
     * 资料包Id
     */
    private Long materialId;

    /**
     *
     *最终来源Id ：  文章ID  问答ID
     */
    private Long sourceId;

    /**
     *
     *最终来源类型 ：1:文章  2:问答
     * @see cn.com.duiba.kjy.api.enums.explosioncontent.FaqClueSourceTypeEnum
     */
    private Integer sourceType;

    /**
     *
     *来源位置 0:无 1:文章内  2:个人专栏
     * @see cn.com.duiba.kjy.api.enums.explosioncontent.LocationSourceEnum
     */
    private Integer locationSource;

    /**
     * 领取赠险人姓名（赠险，资料包）
     */
    private String insuranceName;

    /**
     * 领取赠险人手机号（赠险，资料包）
     */
    private String insurancePhone;

    /**
     *  是否延迟推送
     */
    private Boolean delayFlag;

}
