package cn.com.duiba.kjy.api.remoteservice.guess;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.guess.GuessQuesContentDto;
import cn.com.duiba.kjy.api.params.PageQuery;
import cn.com.duiba.kjy.api.params.guess.GuessContentSaveDto;

import java.util.List;

/**
 * 猜你所想文章 rpc
 * @author 吴文哲
 * @date 2021/4/30 2:00 下午
 **/
@AdvancedFeignClient
public interface RemoteGuessQuesContentService {

    /**
     * 根据主键id 查询
     * @param id 主键id
     * @return 猜你所想文章
     */
    GuessQuesContentDto getById(Long id);

    /**
     * 根据文章id 查询猜你所想文章详情
     * @param contentId 文章id
     * @return 猜你所想文章
     */
    GuessQuesContentDto findByContentId(Long contentId);

    /**
     * 查询猜你所想文章列表
     * @param id 主键id
     * @param contentId 文章id
     * @param pageQuery 分页参数
     * @return 猜你所想列表
     */
    List<GuessQuesContentDto> listGuessQuesContent(Long id, Long contentId, PageQuery pageQuery);

    /**
     * 统计猜你所想文章
     * @param id 主键id
     * @param contentId 文章id
     * @return 统计数量
     */
    Integer countGuessQuesContent(Long id, Long contentId);

    /**
     * 根据主键逻辑删除
     * @param contentId 文章id
     * @return 影响行数
     */
    Integer logicDeleteByContentId(Long contentId);


    /**
     * 保存猜你所想文章
     * @param guessQuesContentEntity 猜你所想文章详情
     * @return 影响行数
     */
    Integer saveGuessQuesContent(GuessQuesContentDto guessQuesContentEntity);


    /**
     * 修改猜你所想文章配置
     * @param contentSaveDto 猜你所想文章配置信息
     * @return 影响行数
     */
    Integer updateGuessContent(GuessContentSaveDto contentSaveDto);




}
