package cn.com.duiba.kjy.api.remoteservice.invitationLetter;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.invitationLetter.InvitationLetterDetailDto;
import cn.com.duiba.kjy.api.dto.invitationLetter.InvitationLetterExtDto;
import cn.com.duiba.kjy.api.dto.invitationLetter.InvitationLetterListDto;
import cn.com.duiba.kjy.api.dto.invitationLetter.InvitationLetterListForBackendDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.content.InvitationLetterExtSearchParams;
import cn.com.duiba.kjy.api.params.content.SearchInvitationLetterParam;

/**
 * 邀请函ext rpc服务接口
 * @author 吴文哲
 * @date 2020-02-19 11:30
 **/
@AdvancedFeignClient
public interface RemoteInvitationLetterExtService {

    /**
     * 分页查询-管理后端专用
     * @param params 分页参数
     * @return 邀请函列表及分页参数
     */
    Page<InvitationLetterListForBackendDto> findPageForBackend(SearchInvitationLetterParam params);

    /**
     * 分页查询-手机端
     * @param params 分页参数
     * @return 邀请函列表
     */
    Page<InvitationLetterListDto> findPage(InvitationLetterExtSearchParams params);

    /**
     * 根据邀请函ID查询(包含扩展信息)
     * @param id 邀请函ID，对应tb_content.id
     * @return 邀请函详情
     */
    InvitationLetterDetailDto findById(Long id);

    /**
     * 根据邀请函ID查询扩展信息
     * @param id 邀请函ID，对应tb_content.id
     * @return 邀请函扩展信息
     */
    InvitationLetterExtDto findExtById(Long id);

    /**
     * 新增或更新
     * @param dto 邀请函详情
     * @return 主键
     * @throws KjyCenterException 新增或更新失败的自定义异常
     */
    Long saveOrUpdate(InvitationLetterDetailDto dto) throws KjyCenterException;
}
