package cn.com.duiba.kjy.api.remoteservice.kol;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.kol.KolSellerDto;

import java.util.List;

/**
 * KOL代理人服务
 * @author zhanghuifeng
 * date 2020/10/20-17:09
 */
@AdvancedFeignClient
public interface RemoteKolSellerService {

    /**
     * 插入（存在即更新）
     * @param dto
     * @return
     */
    Boolean insertExistUpdate(KolSellerDto dto);

    /**
     * 根据代理人ID查询
     * @param sellerId
     * @return
     */
    KolSellerDto findBySellerId(Long sellerId);

    /**
     * 根据代理人ID批量查询
     * @param sellerIds
     * @return
     */
    List<KolSellerDto> listBySids(List<Long> sellerIds);
}
