package cn.com.duiba.kjy.api.enums.version;

import java.util.Objects;

/**
 * 修改版本的操作员的类型枚举
 * @author 吴文哲
 * @date 2020-02-06 22:39
 **/
public enum OperatorTypeEnum {

    USER(1,"普通非付费用户"),
    VIP_USER(2,"VIP用户"),
    BACKEND_OPERATOR(3,"后台运营人员"),
    ;

    /**
     * 类型
     */
    private Integer type ;

    /**
     * 描述
     */
    private String desc;


    OperatorTypeEnum(Integer type,String desc){
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static OperatorTypeEnum getByType(Integer version){
        for (OperatorTypeEnum enumVal : OperatorTypeEnum.values()) {
            if (Objects.equals(version, enumVal.getType())) {
                return enumVal;
            }
        }
        return null;
    }
}
