package cn.com.duiba.kjy.api.remoteservice.clockin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.clockin.ClockInTaskConfDto;

import java.util.List;

/**
 * 打卡任务配置
 *
 * @author xuzhigang
 * @date 2021/4/14 10:56 上午
 **/
@AdvancedFeignClient
public interface RemoteClockInTaskConfService {
    /**
     * 根据打卡规则id查询对应任务信息
     *
     * @param clockInRuleConfId 打卡规则id
     * @return 打卡任务配置
     */
    List<ClockInTaskConfDto> getListByClockInId(Long clockInRuleConfId);

    /**
     * save
     *
     * @param clockInTaskConfDto 打卡任务配置
     * @return 执行结果
     */
    int save(ClockInTaskConfDto clockInTaskConfDto);
}
