package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpActivityCompleteDetailDto;

import java.util.List;
import java.util.Map;

/**
 * 活动完成明细
 *
 * @author ZhangJun
 * @date 2021/10/29 5:00 下午
 */
@AdvancedFeignClient
public interface RemoteCorpActivityCompleteDetailService {

    /**
     * 插入活动完成明细
     *
     * @param dto 活动完成明细
     * @return 执行结果
     */
    boolean insert(CorpActivityCompleteDetailDto dto);

    /**
     * 批量插入活动完成明细
     *
     * @param dtos 活动完成明细集合
     * @return 执行结果
     */
    boolean batchInsert(List<CorpActivityCompleteDetailDto> dtos);

    /**
     * 更新活动完成状态
     *
     * @param id             主键id
     * @param completeResult 完成状态
     * @return 更新结果
     */
    boolean updateCompleteResult(Long id, Integer completeResult);

    /**
     * 批量更新活动完成状态
     *
     * @param ids             主键id集合
     * @param completeResult 完成状态
     * @return 更新结果
     */
    boolean batchUpdateCompleteResult(List<Long> ids, Integer completeResult);

    /**
     * 根据活动ID+公司Id+工号查询活动完成明细
     *
     * @param activityId 活动id
     * @param companyId  公司id
     * @param jobNumber  工号
     * @return 活动完成明细
     */
    CorpActivityCompleteDetailDto findBySomeIndex(Long activityId, Long companyId, String jobNumber);

    /**
     * 根据活动ID+公司Id+工号批量查询活动完成明细
     *
     * @param activityId 活动id
     * @param companyId  公司id
     * @param jobNumbers  工号集合
     * @return 活动完成明细
     */
    List<CorpActivityCompleteDetailDto> findByJobNumbers(Long activityId, Long companyId, List<String> jobNumbers);

    /**
     * 批量查询员工活动完成状态
     *
     * @param companyId  公司id
     * @param jobNumber  工号
     * @param activityIds 活动id
     * @return 完成状态
     */
    Map<Long, Integer> batchSelectCompleteResult(Long companyId, String jobNumber, List<Long> activityIds);

    /**
     * 根据活动ID和完成结果查询工号列表
     * @param activityId     活动ID
     * @param completeResult 完成结果 {@link cn.com.duiba.kjy.api.enums.corp.ActivityCompleteResultEnum}
     * @return 工号列表
     */
    List<String> listJobNumberByActivityIdAndResult(Long activityId, Integer completeResult);

}
