package cn.com.duiba.kjy.api.remoteservice.appvideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoCustomTemplateDto;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-08-10 15:16
 * 跟拍助手app-用户自定义视频模板
 */
@AdvancedFeignClient
public interface RemoteCustomTemplateApiService {

    /**
     * 根据用户id和模板id列表查询自定义模板列表
     * @param userId 用户id
     * @param templateIds 自定义模板列表
     * @return 自定义模板列表
     */
    List<AppVideoCustomTemplateDto> searchCustomTemplateList(Long userId, List<Long> templateIds);

    /**
     * 根据用户id和模板id查询自定义模板
     * @param userId 用户id
     * @param templateId 自定义模板
     * @return 自定义模板列表
     */
    AppVideoCustomTemplateDto findCustomTemplate(Long userId, Long templateId);

    /**
     * 新增/编辑用户自定义模板
     * @param dto 用户自定义模板
     * @return 自定义模板
     */
    boolean saveCustom(AppVideoCustomTemplateDto dto);

    /**
     * 删除用户自定义模板
     * @param templateId 模板id
     * @param userId 用户id
     * @return 删除结果
     */
    boolean deleteCustom(Long templateId, Long userId);
}
