package cn.com.duiba.kjy.api.remoteservice.exclusive;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.exclusive.ExclusiveAreaItemConfDto;

import java.util.List;

/**
 * 公司专区内容配置
 *
 * @author ZhangJun
 * @date 2021/11/25 3:41 下午
 */
@AdvancedFeignClient
public interface RemoteExclusiveAreaItemConfService {

    /**
     * 批量保存公司专区内容配置
     *
     * @param dtos 公司专区内容配置
     * @return 保存结果
     */
    boolean batchSave(List<ExclusiveAreaItemConfDto> dtos);

    /**
     * 保存公司专区内容配置
     *
     * @param dto 公司专区内容配置
     * @return 保存结果
     */
    boolean save(ExclusiveAreaItemConfDto dto);

    /**
     * 根据专区内容id批量删除配置
     *
     * @param itemId 专区内容id
     * @return 删除结果
     */
    boolean deleteAllByItemId(Long itemId);

    /**
     * 根据专区内容id查询配置
     *
     * @param itemId 专区内容id
     * @return 配置列表
     */
    List<ExclusiveAreaItemConfDto> listByItemId(Long itemId);

    /**
     * 根据专区内容id批量查询配置
     *
     * @param itemIds 专区内容id集合
     * @return 配置列表
     */
    List<ExclusiveAreaItemConfDto> listByItemIds(List<Long> itemIds);

}
