package cn.com.duiba.kjy.api.remoteservice.exclusive;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.exclusive.ExclusiveInsuranceDto;

import java.util.List;

/**
 * 公司专区赠险
 *
 * @author ZhangJun
 * @date 2021/11/24 10:14 上午
 */
@AdvancedFeignClient
public interface RemoteExclusiveInsuranceService {

    /**
     * 批量保存公司专区赠险
     *
     * @param entities 公司专区赠险
     * @return 保存结果
     */
    boolean batchSave(List<ExclusiveInsuranceDto> entities);

    /**
     * 保存公司专区赠险
     *
     * @param entity 公司专区赠险
     * @return 保存结果
     */
    boolean save(ExclusiveInsuranceDto entity);

    /**
     * 编辑公司专区赠险
     *
     * @param entity 公司专区赠险
     * @return 编辑结果
     */
    boolean update(ExclusiveInsuranceDto entity);

    /**
     * 编辑公司专区赠险开关状态
     *
     * @param id  公司专区赠险id
     * @param status 赠险状态
     * @return 开关结果
     */
    boolean switchStatus(Long id, Integer status);

    /**
     * 根据公司id查询所有关联的赠险
     *
     * @param companyId 公司id
     * @return 公司赠险列表
     */
    List<ExclusiveInsuranceDto> listByCompanyId(Long companyId);

    /**
     * 根据公司id查询指定开关状态的赠险
     *
     * @param companyId  公司id
     * @param status 开关状态
     * @return 公司赠险列表
     */
    List<ExclusiveInsuranceDto> listByCompanyIdAndStatus(Long companyId, Integer status);

    /**
     * 根据主键id批量查询赠险
     *
     * @param ids 主键id集合
     * @return 赠险集合
     */
    List<ExclusiveInsuranceDto> listByIds(List<Long> ids);

}
