package cn.com.duiba.kjy.api.dto.corp;

import lombok.Data;

import java.io.Serializable;

/**
 * 企业后台-驾驶舱页面
 *
 * @author zhanghuifeng
 * @date 2021/8/25 13:46
 */
@Data
public class CorpPageDto implements Serializable {

    private static final long serialVersionUID = -7572502052713065292L;

    /**
     * 主键Id
     */
    private Long id;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 页面名称
     */
    private String pageName;

    /**
     * 页面url
     */
    private String pageUrl;

    /**
     * 页面状态，0-展示，1-隐藏
     * @see cn.com.duiba.kjy.api.enums.corp.PageVisibleEnum
     */
    private Integer hideState;

    /**
     * 管理员类型
     * {@link cn.com.duiba.kjy.api.enums.corp.StaffTypeEnum}
     */
    private Integer staffType;
}
