package cn.com.duiba.kjy.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.companyTradeAppraiseTemplate.CompanyTradeAppraiseTemplateDto;
import cn.com.duiba.kjy.api.params.company.CompanyTradeAppraiseListParam;

import java.util.List;

/**
 * 公司企业评价模版
 * @Author chentiecheng
 * @Date 2020/5/8 3:35 下午
 */
@AdvancedFeignClient
public interface RemoteCompanyTradeAppraiseTemplateService {

    /**
     * 统计总数
     * @param param
     * @return
     */
    Long selectCount(CompanyTradeAppraiseListParam param);

    /**
     * 根据条件分页查询个人介绍模板
     * @param param
     * @return
     */
    List<CompanyTradeAppraiseTemplateDto> selectListByParam(CompanyTradeAppraiseListParam param);

    /**
     * 新增个人介绍模板
     * @param dto
     * @return
     */
    Boolean insert(CompanyTradeAppraiseTemplateDto dto);

    /**
     * 更新个人介绍模板
     * @param dto
     * @return
     */
    Boolean update(CompanyTradeAppraiseTemplateDto dto);

    /**
     * 删除个人介绍模板
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 根据id查询案例模版
     * @param id
     * @return
     */
    CompanyTradeAppraiseTemplateDto selectById(Long id);
}
