package cn.com.duiba.kjy.api.remoteservice.home;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.home.SpecialTopicDto;
import cn.com.duiba.kjy.api.enums.home.SpecialTopicStateEnum;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.home.SpTopicSearchParams;

/**
 * @auther: linjianhui
 * @date: 2019-11-28 18:02
 * @description: 首页专题
 * 附：
 * 添加，编辑专题状态都用枚举：SpecialTopicStateEnum，查询不做强制要求
 */
@AdvancedFeignClient
public interface RemoteSpecialTopicService {

    /**
     * 插入专题
     * @param dto
     * @return
     */
    Long save(SpecialTopicDto dto);

    /**
     * 编辑专题
     * @param dto
     * @return
     */
    Integer update(SpecialTopicDto dto);

    /**
     * 发布/撤回
     * @param id
     * @param state
     * @return
     */
    Boolean changeState(Long id, SpecialTopicStateEnum state);

    /**
     * 查询专题
     * @param topicId
     * @return
     */
    SpecialTopicDto findByTopicId(Long topicId);

    /**
     * 获取上一篇文章
     * @param topicId
     * @return
     */
    SpecialTopicDto findPrevByTopicId(Long topicId);

    /**
     * 查询首页专题（最新的一篇）
     * @return
     */
    SpecialTopicDto getHomeSpecialTopic();

    /**
     * 查询专题列表
     * @param params
     * @return
     */
    Page<SpecialTopicDto> selectList(SpTopicSearchParams params);

}
