package cn.com.duiba.kjy.api.remoteservice.timingLottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.timingLottery.TimingLotteryConfigDto;
import cn.com.duiba.kjy.api.params.timingLottery.TimingLotteryDrawParam;
import cn.com.duiba.kjy.api.params.timingLottery.TimingLotteryListParam;

import java.util.List;

/**
 * Service
 *
 * @author xiaotian
 * 2021-1-6 11:15:59
 */
@AdvancedFeignClient
public interface RemoteTimingLotteryConfigService {
    /**
     * 新增记录
     */
    Long save(TimingLotteryConfigDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(TimingLotteryConfigDto dto);

    /**
     * 根据id获取
     */
    TimingLotteryConfigDto getById(Long id);

    /**
     * 获取待开奖的数量
     *
     * @param sellerId
     * @return
     */
    Integer countInUse(Long sellerId);

    /**
     * 筛选抽奖列表
     *
     * @param timingLotteryListParam
     * @return
     */
    List<TimingLotteryConfigDto> getTimingLotteryList(TimingLotteryListParam timingLotteryListParam);

    /**
     * 筛选抽奖列表(数量)
     *
     * @param timingLotteryListParam
     * @return
     */
    Long getTimingLotteryCount(TimingLotteryListParam timingLotteryListParam);

}
