package cn.com.duiba.kjy.api.dto.corp;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhanghuifeng
 * @create 2021-11-02 16:13
 * @descript 企业员工简单信息
 */
@Data
public class CorpEmployeeSimpleDto implements Serializable {

    private static final long serialVersionUID = -8455803353657270169L;
    /**
     * 企业员工主键
     */
    private Long id;

    /**
     * 公司ID，tb_corp_company.id
     * not null default = null
     */
    private Long companyId;

    /**
     * 营业部ID，tb_corp_company_dept.id
     * not null default = null
     */
    private Long deptId;

    /**
     * 工号
     * max length = 200
     * not null default = null
     */
    private String jobNumber;

    /**
     * 员工姓名
     * max length = 15
     * not null default =
     */
    private String employeeName;

    /**
     * 手机号
     * max length = 30
     * not null default =
     */
    private String employeePhone;

    /**
     * 职位
     * max length = 128
     * not null default =
     */
    private String jobPost;

    /**
     *
     *是否删除，1=已删除，0=未删除
     * not null default = 0
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
     */
    private Integer logicDeleted;

}
