package cn.com.duiba.kjy.api.dto.seller;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author ZhangJun
 * @date 2021/11/3 10:00 下午
 */
@Data
public class SellerAndRecordDto implements Serializable {

    private static final long serialVersionUID = 6818901250352240738L;

    /**
     * 主键，tb_seller.id
     * not null
     */
    private Long id;

    /**
     * vip级别，0=不是、1=是
     * not null
     */
    private Integer vip;

    /**
     * vip开始时间
     * not null
     */
    private Date vipBeginTime;

    /**
     * 变更后的vip结束时间
     * not null
     */
    private Date vipEndTime;

    /**
     * 变更之前的截止时间
     * not null
     */
    private Date originalEndTime;

    /**
     * 变更原因
     * {@link cn.com.duiba.kjy.enums.VipChangeReasonEnum}
     */
    private Integer changeReason;

    /**
     * 用户版本
     * {@link cn.com.duiba.kjy.api.enums.version.UserVersionEnum}
     * not null
     */
    private Integer userVersion;

}
