package cn.com.duiba.kjy.api.enums.corp;

import java.util.Objects;

/**
 * 企业后台导入任务状态
 * @author zhanghuifeng
 * @date 2021-10-28
 */
public enum CorpImportTaskStatusEnum {

    //状态：1=未执行、2=执行中、3=调用失败、4=执行失败、5=执行成功、6=完成
    UN_EXECUTED(1, "未执行"),
    EXECUTING(2, "执行中"),
    CALL_FAILED(3, "调用失败"),
    EXEC_FAILED(4, "执行失败"),
    EXEC_SUCCESS(5, "执行成功"),
    COMPLETE(6, "完成");

    private Integer code;

    private String desc;

    CorpImportTaskStatusEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static CorpImportTaskStatusEnum getByCode(Integer code) {
        for (CorpImportTaskStatusEnum enumVal : CorpImportTaskStatusEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        CorpImportTaskStatusEnum statusEnum = getByCode(code);
        if (Objects.isNull(statusEnum)) {
            return "";
        }
        return statusEnum.getDesc();
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
