package cn.com.duiba.kjy.api.enums.sellercustomerintention;

import java.util.Objects;

/**
 * @author wangbinbin
 * @create 2020-09-21 15:21
 * @descript 客户意向度数据位数枚举(从左往右)
 */
public enum SellerCustomerIntentionClueEnum {

    RISK_GAME(0, 11,"普通线索包括参与测评未领取报告"),
    FAQ(1, 27, "查看FAQ"),
    RISK_TEST(2, 32, "参与测评并领取报告"),
    WELFARE_INSURANCE(3,31,"领取赠险"),
    FAQ_VISIT_SCAN(4, 29, "领取资料"),
    FAQ_VISIT_ASK(5,28, "点击咨询"),
    FAQ_VISIT_EXTRA_QUESTION(6,30, "点击提问"),
    ;

    /**
     * 位数
     */
    private Integer index;

    /**
     * 线索类型
     */
    private Integer clueType;

    /**
     * 描述
     */
    private String description;

    SellerCustomerIntentionClueEnum(Integer index, Integer clueType, String description) {
        this.index = index;
        this.clueType = clueType;
        this.description = description;
    }

    public Integer getIndex() {
        return index;
    }

    public Integer getClueType() {
        return clueType;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 根据线索类型获取
     * @param clueType
     * @return
     */
    public static SellerCustomerIntentionClueEnum getByClueType(Integer clueType) {
        if (Objects.isNull(clueType)) {
            return null;
        }
        for (SellerCustomerIntentionClueEnum clueEnum : SellerCustomerIntentionClueEnum.values()) {
            if (Objects.equals(clueEnum.getClueType(), clueType)) {
                return clueEnum;
            }
        }
        return null;
    }
}
