package cn.com.duiba.kjy.api.remoteservice.reward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.reward.RewardVideoStatsDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2021-03-19 17:44
 * @descript 视频统计 remoteSerivce
 */
@AdvancedFeignClient
public interface RemoteRewardVideoStatsApiService {

    /**
     * 新增记录
     * @param dto 记录
     * @return 新增结果
     */
    boolean save(RewardVideoStatsDto dto);

    /**
     * 增加使用次数
     * @param id 主键
     * @param increaseNum 增加次数
     * @return 增加结果
     */
    boolean increaseUserNum(Long id, int increaseNum);

    /**
     * 根据视频id查询
     * @param videoId 视频id
     * @return 视频统计dto
     */
    RewardVideoStatsDto findByVideoId(Long videoId);

    /**
     * 根据视频ids查询列表
     * @param videoIds 视频ids
     * @return 列表数据
     */
    List<RewardVideoStatsDto> findByVideoIds(List<Long> videoIds);
}
