package cn.com.duiba.kjy.api.util;

/**
 * @author zhanghuifeng
 * date 2019-04-30-17:02
 */
public enum RedisKeyFactory {

    K001("涉及到专区内容排序操作 分布式锁"),

    K002("每日推送消息,17点确定的文章ids"),

    K003("插入销售员导入任务 分布式锁"),

    K004("销售员导入热门文章"),

    K005("唤醒代理人的热门文章"),

    K006("userId 白名单"),

    K007("openId 白名单"),

    K008("公众号缓存"),

    K009("消息配置根据id查询的缓存"),

    K010("消息配置根据oaId_mark 的缓存"),

    K011("消息配置根据mark的缓存"),

    K012("私信"),

    K013("首页分类排序安全锁"),

    K014("分类下的内容历史总数"),

    K015("首页内容排序安全锁"),

    K016("添加中奖人 分布式锁"),

    K017("增加销售员邀请成功开通人数 分布式锁"),

    K018("周报代理人排名"),

    K019("平台代理人总数"),

    K020("获取名片SCID锁"),

    K021("缓存名片"),

    K022("收藏名片锁"),

    K023("添加审核记录锁"),

    K024("审核锁"),

    K025("获取用户小程序模版消息formId"),

    K026("销售员卡片信息scId"),

    K027("转发锁"),

    K028("分享分页数据"),

    K029("生产上动画 缓存"),

    K030("动画预览token"),

    K031("查询中秋领祝福信息 缓存"),

    K032("代理人新手任务列表"),

    K033("点赞互动 缓存"),

    K034("根据主键查询互动详情 缓存"),

    K035("根据scId查询互动详情 缓存"),

    K036("根据contentId查询互动详情 缓存"),

    K037("保存内容互动信息 分布式锁"),

    K038("根据主键查询互动模板详情 缓存"),

    K039("根据标签随机获取模板 缓存"),

    K040("代理人分享内容得分缓存"),

    K041("代理人所有客户意向度得分缓存"),

    K042("代理人客户来源信息缓存"),

    K045("互动题库通用模板ID集合 缓存"),

    K046("名片模块化顶部缓存"),

    K047("名片插入redis锁"),

	K050("tb_content表内容缓存"),

	K051("每日热文缓存"),

	K060("抽奖次数 分布式锁"),

    K061("抽奖参与次数"),

    K062("抽奖分享次数"),

    K063("抽奖 分布式锁"),

    K064("查询抽奖游戏与奖品配置 缓存"),

    K065("销售员活动信息详情 缓存"),

    K066("根据活动ID获取抽奖游戏ID 缓存"),

    K067("活动配置ID获取中奖人列表 缓存"),

    K068("活动配置ID获取自定义奖品 缓存"),

    K069("根据内容ID查询小游戏 缓存"),

    K070("代理人更新客户额外资料分布式锁"),

    K071("用户收藏防并发锁"),

    K072("是否开启免打扰缓存"),

	K073("在一定时间范围内，访客访问的不同代理人数"),

    K074("代理人配置缓存"),

    K075("新手任务完成分布式锁"),

	K076("分销返现分布式锁"),

    K078("插入新的收藏记录加锁"),

    K079("定时任务sellerContent历史数据缓存"),

    K080("根据配置ID，获取配置详情"),

    K081("贺卡打开scid纬度统计 分布式锁"),

    K082("趣味测试scid纬度统计 分布式锁"),

    K083("猜你想问,文章关联问题缓存"),

    K088("类似hbase的键值对long类型更新分布式锁"),

    K089("类似hbase的键值对string类型更新分布式锁"),

    K090("热榜数据缓存"),

    K091("首页推荐专题缓存"),

    K092("管理端移动公司动态位置"),

    K093("管理端移动荣誉认证位置"),

    K094("管理端移动FAQ分类标签位置"),

    K095("管理端移动成功案例位置"),

    K096("管理端移动标签下的常见问题位置"),

    K097("客户成功案例新增分布式锁"),

    K098("客户成功案例移动分布式锁"),

	K100("动态数据源配置开关"),

    K101("精准素材内容ID排行榜"),

    K102("个人精准素材排行榜阅读记录"),

    K103("精准素材内容ID排行榜V2"),

    K104("个人精准素材排行榜阅读记录V2"),

    K105("更新全网链接标题"),

    K106("销售员导入热门视频"),

    K107("用户版本信息缓存"),

    K108("邀请函配置详情缓存"),

    K109("贺卡打开统计 分布式锁"),

    K110("代理人节日贺卡配置缓存"),

    K111("节日贺卡访问记录"),

    K112("代理人节日贺卡每日配置数量"),

    K113("分享入口配置"),

    K114("分享入口模版缓存"),

    K115("省市区缓存"),

    K116("发圈素材二级标签下的总分享数缓存 缓存"),

    K117("标签Id缓存"),

    K118("客户评价代理人纬度redis锁"),

    K119("调用兑吧支付 分布式锁"),

    K120("领取红包 分布式锁"),

    K121("版本对应使用用户数据缓存"),

    K122("新增版本信息分布式锁"),

    K124("用户权限缓存"),

    K125("必转素材缓存"),

    K126("爆款素材缓存"),

    K127("访客领取礼物并发锁"),

    K128("贺卡分享配置缓存"),

    K129("微信标签 分布式锁"),

    K130("发圈素材标签下总转发数量缓存"),

    K132("贺卡转发数最高的贺卡缓存"),

    K133("内部销售缓存"),

	K134("代理人团队绑定/删除上下级 分布式锁"),

    K135("代理人初始化看板数据 分布式锁"),

    K136("推荐文章分布式锁"),

    K137("荣誉相册代理人配置缓存"),

    K138("激活预设会员分布式锁"),

    K139("预设会员，保存预设信息 分布式锁"),

    K140("退款审核分布式锁"),

    K141("管理端移动使用案例位置"),

    K142("新增销售每日打卡记录"),

    K143("新增销售每周打卡记录"),

    K144("最新问答记录ID缓存"),

    K145("根据焦虑类型获取的最新问答记录"),

    K146("访客产生faq线索的缓存"),

    K147("代理人上传总数缓存"),

    K148("访客产生faq咨询额外问题线索的缓存"),

    K149("需要唤醒的代理人"),

    K150("代理人访客产生线索数缓存"),

    K151("建议话术缓存"),

    K152("成功案例缓存"),

    K153("动画内容缓存"),

    K154("弹窗配置自定义推送销售id列表"),

    K155("口以用户缓存"),

    K156("每日生成课程锁"),

    K157("客户案例主推记录"),

    K158("客户意向度"),


    K159("完成60天开单计划分布式锁"),

	K160("初始化60天开单计划锁"),

    K161("60天开单失败体验锁"),

	K162("补卡分布式锁"),

    K163("新增第三方用户分布式锁"),

    K164("绑定第三方用户分布式锁"),

    K165("60天开单打卡奖励领取锁"),

    K166("60天开单打卡领取补卡券锁"),

    K167("60天开单打卡补卡锁"),

	K168("完成60天开单打卡分布式锁"),

    K169("初始化60天开单打卡锁"),

    K170("问卷调研用户提交答案并发锁"),

    K171("60天打卡领取带来源的补卡卷并发锁"),

    K172("非会员代理人转发文章数缓存"),

    K173("定时抽奖分布式锁"),

    K174("定时抽奖详情缓存"),

    K175("预设会员，保存预设信息 分布式锁"),

    K176("视频抽奖，单个视频缓存"),

    K177("打卡规则配置 根据打卡规则id缓存"),

    K178("打卡任务配置 根据打卡规则id缓存"),

    K179("访客线索重复推送 当日线索推送次数缓存"),

    K180("打卡任务配置 根据任务类型缓存"),

    K181("创建今日打卡任务 分布式锁"),

    K182("创建打卡任务 分布式锁"),

    K183("nps提交答案分布式锁"),

    K184("nps配置缓存"),

    K185("nps问题配置缓存"),

    K186("跟拍助手-视频模板列表-缓存"),

    K187("跟拍助手-视频模板-缓存"),

    K188("跟拍助手-视频模板ext信息-缓存"),

    K189("跟拍助手-相框列表-缓存"),

    K190("跟拍助手-视频模板列表-普通视频-缓存"),

    K191("跟拍助手-视频模板保存分布式锁"),

    K192("跟拍APP-banner资源位排序分布式锁"),

    K193("跟拍APP-视频模板排序分布式锁"),

    K194("企业版-客户每周新增数量统计"),

    K195("企业版-客户激活分布式锁"),

    K196("代理人访客领取公司赠险线索缓存"),

    K197("是否开启免打扰缓存-新"),
    ;

    private static final String SPACE = "KjyCenter";
    private static final String SEPARATOR = "_";

    String desc;

    RedisKeyFactory(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
