package cn.com.duiba.kjy.api.enums.home;

import java.util.HashMap;
import java.util.Map;

/**
 * @auther: linjianhui
 * @date: 2019-12-03 17:00
 * @description:
 */
public enum SpecialTopicStateEnum {

    /**
     * 首页专题状态
     */
    DRAFT(1, "草稿"),
    AVAILABLE(2, "已发布"),
    ;

    private Integer code;
    private String desc;

    SpecialTopicStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, SpecialTopicStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(SpecialTopicStateEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static SpecialTopicStateEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }}
