package cn.com.duiba.kjy.api.remoteservice.interact;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.interact.InteractSolutionDto;
import cn.com.duiba.kjy.api.params.interact.InteractSolutionSearchParam;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-07-26 09:41
 * 互动方案rpc service
 */
@AdvancedFeignClient
public interface RemoteInteractSolutionApiService {

    /**
     * 统计互动方案数据条数（仅管理后台可用！！）
     * @param param 查询参数
     * @return 互动方案数据条数
     */
    int countSolution(InteractSolutionSearchParam param);

    /**
     * 查询互动方案
     * @param param 查询参数
     * @return 互动方案
     */
    List<InteractSolutionDto> searchList(InteractSolutionSearchParam param);

    /**
     * 通过id获取互动方案
     * @param id 通过id获取互动方案
     * @return 互动方案
     */
    InteractSolutionDto findById(Long id);

    /**
     * 通过id数组获取互动方案
     * @param ids 通过ids获取互动方案
     * @return 互动方案
     */
    List<InteractSolutionDto> findByIds(List<Long> ids);

    /**
     * 通过活动名称获取互动方案
     * @param activityName 活动名称
     * @return 互动方案id
     */
    List<Long> findIdsByActivityName(String activityName);

    /**
     * 保存互动方案
     * @param dto 互动方案
     * @return 保存结果
     */
    int save(InteractSolutionDto dto);

    /**
     * 编辑互动方案
     * @param dto 互动方案
     * @return 编辑结果
     */
    int update(InteractSolutionDto dto);

    /**
     * 删除互动方案
     * @param id 互动方案id
     * @return 删除结果
     */
    int delete(Long id);
}
