package cn.com.duiba.kjy.api.enums.lottery;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/10/23 3:07 PM
 */
public enum LotteryStateEnum {
    DRAFT(0, "草稿"),
    OPEN(1, "开启"),
    CLOSE(2, "关闭"),
    ;

    private Integer type;

    private String desc;

    LotteryStateEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, LotteryStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LotteryStateEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getType(), stateEnum);
        }
    }

    public static LotteryStateEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}

