package cn.com.duiba.kjy.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.crm.CrmSellerDailyPaperCountDto;
import cn.com.duiba.kjy.api.dto.crm.CrmSellerDailyPaperRecordDto;
import cn.com.duiba.kjy.api.params.crm.CrmSellerDailyPaperRecordParam;

import java.util.Date;
import java.util.List;

/**
 * @author wangbinbin
 * @create 2021-01-05 10:28
 * @descript Crm销售日报remoteService
 */
@AdvancedFeignClient
public interface RemoteCrmSellerDailyPaperRecordService {

    /**
     * 根据日报id查询日报详情
     * @param recordId
     * @return
     */
    CrmSellerDailyPaperRecordDto findById(Long recordId);

    /**
     * 根据param查询列表
     * @param param
     * @return
     */
    List<CrmSellerDailyPaperRecordDto> listByParam(CrmSellerDailyPaperRecordParam param);

    /**
     * 根据param查询总数
     * @param param
     * @return
     */
    int countByParam(CrmSellerDailyPaperRecordParam param);

    /**
     * 新增一条日报记录
     * @param dailyPaperRecordDto
     * @return 记录id
     */
    long add(CrmSellerDailyPaperRecordDto dailyPaperRecordDto);

    /**
     * 根据日报id更新
     * @param dailyPaperRecordDto
     * @return
     */
    int updateById(CrmSellerDailyPaperRecordDto dailyPaperRecordDto);

    /**
     * 寻找上一篇日报
     * @param recordId
     * @param recordGmtCreate
     * @param crmSellerId
     * @param startDatetime
     * @param endDatetime
     * @return
     */
    CrmSellerDailyPaperRecordDto findPreRecord(Long recordId, Date recordGmtCreate, Long crmSellerId, Date startDatetime, Date endDatetime);

    /**
     * 寻找下一篇日报
     * @param recordId
     * @param recordGmtCreate
     * @param crmSellerId
     * @param startDatetime
     * @param endDatetime
     * @return
     */
    CrmSellerDailyPaperRecordDto findNextRecord(Long recordId, Date recordGmtCreate, Long crmSellerId, Date startDatetime, Date endDatetime);

    /**
     * 去重查询日报数
     * @param param
     * @return
     */
    int distinctSellerCountByParam(CrmSellerDailyPaperRecordParam param);

    /**
     * 查询时间段内提交日报的代理人id
     * @param param
     * @return
     */
    List<Long> listDistinctSellerIds(CrmSellerDailyPaperRecordParam param);

    /**
     * 根据日期查询总数
     * @param param
     * @return
     */
    List<CrmSellerDailyPaperCountDto> listDistinctSellerCountByParam(CrmSellerDailyPaperRecordParam param);

}
