package cn.com.duiba.kjy.api.constant;

/**
 * Created by zhangshun on 2019/2/13.
 */
public enum UserExtTypeEnum {

    OA("oa", "非VIP公众号"),
    MP("mp", "小程序"),
    VIP("vip","VIP公众号"),
    //!!!important 这不是数据库类型哦！！！ 必须经过userExtService处理
    VIP_OA("vipOa","非VIP和VIP")

    ;

    private String code;
    private String desc;

    UserExtTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static UserExtTypeEnum of(String code) {
        if (code == null) {
            return null;
        }
        for (UserExtTypeEnum typeEnum : UserExtTypeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        throw new UnsupportedOperationException("不支持的ext类型");
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
