package cn.com.duiba.kjy.api.dto.seller;

import cn.com.duiba.kjy.api.enums.seller.DistributionFormalStateEnum;
import cn.com.duiba.kjy.api.enums.seller.DistributionTypeEnum;
import cn.com.duiba.kjy.api.enums.seller.PromotionComboTypeEnum;
import cn.com.duiba.kjy.api.enums.seller.PromotionStateEnum;

import java.io.Serializable;
import java.util.Date;

/**
* 销售员分销关系
*/
public class SellerDistributionDto implements Serializable {

    private static final long serialVersionUID = 1658812721076008804L;

    /**
    * 销售员id
    */
    private Long sellerId;

    /**
    * 上级ID(seller_id)
    */
    private Long superiorId;

    /**
    * 绑定时间
    */
    private Date bindingTime;

    /**
    * 累计推广收益
    */
    private Integer totalPromotionEarnings;

    /**
    * 返现状态 0可返现 1不可返现
     * @see PromotionStateEnum
    */
    private Integer hasPromotion;


    /**
     * 分销状态
     * @see DistributionFormalStateEnum
     */
    private Integer formalState;

    /**
     * 邀请类型
     * @see DistributionTypeEnum
     */
    private Integer distributionType;

    /**
     * 保护期到期时间
     */
    private Date protectExpireDate;

    /**
     * 返现套餐类型
     * @see PromotionComboTypeEnum
     */
    private Integer promotionComboType;

    /**
     * 会销特惠有效期
     */
    private Date spValidDate;

    public Integer getFormalState() {
        return formalState;
    }

    public void setFormalState(Integer formalState) {
        this.formalState = formalState;
    }

    public Integer getDistributionType() {
        return distributionType;
    }

    public void setDistributionType(Integer distributionType) {
        this.distributionType = distributionType;
    }

    public Date getProtectExpireDate() {
        return protectExpireDate;
    }

    public void setProtectExpireDate(Date protectExpireDate) {
        this.protectExpireDate = protectExpireDate;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSuperiorId(Long superiorId) {
        this.superiorId = superiorId;
    }

    public Long getSuperiorId() {
        return superiorId;
    }

    public void setTotalPromotionEarnings(Integer totalPromotionEarnings) {
        this.totalPromotionEarnings = totalPromotionEarnings;
    }

    public Integer getTotalPromotionEarnings() {
        return totalPromotionEarnings;
    }

    public Date getBindingTime() {
        return bindingTime;
    }

    public void setBindingTime(Date bindingTime) {
        this.bindingTime = bindingTime;
    }

    public Integer getHasPromotion() {
        return hasPromotion;
    }

    public void setHasPromotion(Integer hasPromotion) {
        this.hasPromotion = hasPromotion;
    }

    public Integer getPromotionComboType() {
        return promotionComboType;
    }

    public void setPromotionComboType(Integer promotionComboType) {
        this.promotionComboType = promotionComboType;
    }

    public Date getSpValidDate() {
        return spValidDate;
    }

    public void setSpValidDate(Date spValidDate) {
        this.spValidDate = spValidDate;
    }
}

