package cn.com.duiba.kjy.api.enums;

import java.util.Objects;

/**
 * Created by dugq on 2019-06-29.
 * 消息配置的标记。一个功能一个标记。切勿重复哦
 */
public enum MessageMarkEnum {
    DAILY_TEMPLATE(1,"日报降级"),
    VISIT_TEMPLATE(2,"访问记录降级"),
    BUY_VIP_TEMPLATE(3,"会员购买成功"),
    SHARE_STATISTICS_TEMPLATE(4,"每日统计"),
    EVENING_GREETING_TEMPLATE(5,"晚安问候降级"),
    RETURN_MONEY(6,"收益发放通知"),
    WITHDRAW_MONEY(7,"提现成功通知"),
    VIP_INCOME_STATISTICS_TEMPLATE(8,"每日收益模板消息"),
    GUIDING_SUBSCRIBE_VIP(9,"引导关注VIP客服消息"),
    EVENING_GREETING_KEFU(10,"晚安问候客服消息"),
    ;
    private Integer mark;
    private String desc;

    MessageMarkEnum(Integer mark, String desc) {
        this.mark = mark;
        this.desc = desc;
    }

    public Integer getMark() {
        return mark;
    }

    public String getDesc() {
        return desc;
    }

    public static MessageMarkEnum Of(Integer type) {
        for (MessageMarkEnum e :values())
            if (Objects.equals(type, e.getMark())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的消息");
    }

}
