package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.ContentTypeEnum;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.ContentDto;
import cn.com.duiba.kjy.api.dto.ContentExtDto;
import cn.com.duiba.kjy.api.dto.ContentMatrixDto;
import cn.com.duiba.kjy.api.dto.ContentSimpleInfo;
import cn.com.duiba.kjy.api.dto.TodayNewCountDto;
import cn.com.duiba.kjy.api.dto.content.DailySimpleInfoDto;
import cn.com.duiba.kjy.api.params.ContentSearchParams;
import org.joda.time.LocalDate;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteContentService {

    /**
     * 查询文章列表
     * @param contentSearchParams
     * @return
     */
    List<ContentDto> selectList(ContentSearchParams contentSearchParams);

    /**
     * 查询总数
     * @param params
     * @return
     */
    Long selectCount(ContentSearchParams params);

    /**
     * 通过id列表批量查询内容
     * @param ids
     * @return
     */
    List<ContentDto> findByIds(List<Long> ids);

    /**
     * 通过id列表批量查询内容
     * @param ids
     * @return
     */
    List<ContentDto> findAllByIds(List<Long> ids);

    /**
     * 通过id列表批量查询内容
     * @param ids
     * @return
     */
    Map<Long, ContentDto> findAllMapByIds(List<Long> ids);

    /**
     * 根据内容id查询内容，包括扩展信息
     * @param id
     * @return
     */
    ContentExtDto findExtByContentId(Long id);

    /**
     *
     * @param ids
     * @return
     */
    Map<Long, ContentExtDto> findExtByIds(List<Long> ids);

    /**
     * 根据内容ID集合，获取内容推荐语
     * @param ids 内容ID集合
     * @return 推荐语
     */
    Map<Long, String> findRecommendDescByIds(List<Long> ids);

    /**
     *
     * @param ids
     * @return
     */
    Map<Long, ContentMatrixDto> findMatrixByIds(List<Long> ids);

    /**
     * 根据内容id查询内容，包括扩展信息
     * @param id
     * @return
     */
    ContentDto findByContentId(Long id);

    /**
     * 新增内容 包含主体
     * @param contentExtDto
     * @return
     * @throws KjyCenterException
     */
    Long insert(ContentExtDto contentExtDto) throws KjyCenterException;

    /**
     * 跟新内容 包含主体
     * @param contentExtDto
     * @return
     */
    Integer update(ContentExtDto contentExtDto);

    /**
     * 更新内容
     * @param contentExtDto
     * @return
     */
    Boolean updateContent(ContentExtDto contentExtDto);

    /**
     * 跟新内容 包含主体
     *
     * @deprecated
     * @param status
     * @return
     */
    @Deprecated
    Boolean updateStatus(Long id, Integer status) throws KjyCenterException;

    /**
     * 批量删除 包含主体
     * @param ids
     * @return
     */
    Integer bathDelete(List<Long> ids);

    /**
     * 发布/撤回 内容
     * @param id
     * @param open
     * @return
     */
    Integer openContent(Long id, Integer open);

    /**
     * 跟新排序 上移，下移
     * @param id
     * @param sort ： >0 上移 < 0下移
     * @param contentType 内容类型
     * @return
     */
    Integer updateSort(Long id, Integer sort, ContentTypeEnum contentType);


    Integer updateContentTargetDestination(Long id, Integer destination, ContentTypeEnum contentType) throws KjyCenterException;


    /**
     * 跟新文章的敏感词检测结果
     * @param id
     * @param suggestion
     * @return
     */
    Integer updateArticleSuggestion(Long id,String suggestion);

    Integer update2TargetDestination(Long id, Integer destination, ContentSearchParams params) throws BizException;

    /**
     * 文章分享次数加1
     * @param contentId
     * @return
     */
    Boolean sharedNumIncrease(Long contentId,Long sellerId);

    Boolean downloadNumIncrease(Long contentId);

    /**
     * 日报发布
     * @param id
     * @return
     */
    Boolean updateMatrixPriorityGrade(Long id, Integer grade);

    /**
     * 根据指定日期查询是否存在日报
     * @param releaseTime
     * @return
     */
    ContentDto findDailyByDate(Date releaseTime);

    /**
     * 根据指定日期和日报类型查询日报
     * @param releaseTime 日期
     * @param contentType 类型
     * @return 日报
     */
    ContentDto findDailyByDateAndType(Date releaseTime, String contentType);

    /**
     * 日报发布
     * @param id
     * @return
     */
    Boolean openDaily(Long id);

    /**
     * 获取发布中的日报
     * @return
     */
    ContentDto selectInitDaily();

    /**
     * 获取各种类型最近日期的发布中的日报（各种类型各一个）
     * @return 日报
     */
    List<ContentDto> selectInitDailyList();


    ContentDto nextCrawlerArticle(Long id);
    /**
     * 查询文章列表(管理后台专用)
     * @param contentSearchParams
     * @return
     */
    List<ContentDto> selectListForBackend(ContentSearchParams contentSearchParams);

    /**
     * 查询总数(管理后台专用)
     * @param params
     * @return
     */
    Long selectCountForBackend(ContentSearchParams params);

    /**
     * 获取简单信息
     * @param id
     * @param contentType
     * @return
     */
    ContentSimpleInfo findSimpleInfo(Long id, String contentType);

    TodayNewCountDto countTodayNewCountDto(Long tagId);

    /**
     * 获取今日日报简单信息列表
     * @return
     */
    List<DailySimpleInfoDto> findSimpleTodayDaily();


    /**
     * 获取某一天早报数
     * @param date
     * @return
     */
    int countDailyByDate(LocalDate date);

    /**
     * 获取某一天早报列表
     * @param date
     * @return
     */
    List<DailySimpleInfoDto> findSimpleDaily(LocalDate date);

    /**
     * 根据销售员ID和早报ID给单个销售员推送早报(管理后台专用)
     * @param sellerId 销售员ID
     * @param dailyId 早报ID
     * @return true-成功，false-失败
     */
    boolean sendDailyBySeller(Long sellerId, Long dailyId);

    /**
     * 根据活动主键列表获取是否为中奖活动
     * @param contentIds
     * @return
     */
    Map<Long, Boolean> getActivityIsLotteryMap(List<Long> contentIds);

}
