package cn.com.duiba.kjy.api.dto.lottery;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2019/8/1 6:23 PM
 */
@Data
public class LotteryDto implements Serializable {

    private static final long serialVersionUID = 4034598027653979226L;

    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 初始次数
     */
    private Integer initialTimes;

    /**
     * 每次分享增加次数
     */
    private Integer everyShareAddTimes;

    /**
     * 最大次数
     */
    private Integer maxTimes;

    /**
     * 次数类型：0-永久，1-每日
     * @see cn.com.duiba.kjy.api.enums.lottery.LotteryTimesTypeEnum
     */
    private Integer timesType;

    /**
     * 出奖规则：0-概率，1-优先级
     * @see cn.com.duiba.kjy.api.enums.lottery.LotteryRuleEnum
     */
    private Integer lotteryRule;

    /**
     * 是否需要指定中奖人
     * @see cn.com.duiba.kjy.api.enums.lottery.LotteryNeedTypeEnum
     */
    private Integer needWinner;

    /**
     * 是否需要选择优惠券
     * @see cn.com.duiba.kjy.api.enums.lottery.LotteryNeedTypeEnum
     */
    private Integer needChoose;

    /**
     * 奖品列表
     */
    List<LotteryPrizeDto> lotteryPrizes;

}
